/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.mixin.common.dfu;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_9267;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9267.class})
public class MixinItemStackComponentizationFix {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"iPortal_DFU");

    @Inject(method={"fixItemStack"}, at={@At(value="RETURN")})
    private static void onFixItemStack(class_9267.class_9268 itemStackData, Dynamic<?> tag, CallbackInfo ci) {
        if (itemStackData.method_57270("immersive_portals:command_stick")) {
            Optional commandTag = itemStackData.method_57262("command").result();
            Optional nameTranslationKeyTag = itemStackData.method_57262("nameTranslationKey").result();
            Optional descriptionTranslationKeysTag = itemStackData.method_57262("descriptionTranslationKeys").result();
            if (commandTag.isEmpty() || nameTranslationKeyTag.isEmpty() || descriptionTranslationKeysTag.isEmpty()) {
                LOGGER.error("Broken command stick item data {} {} {}", (Object)commandTag, (Object)nameTranslationKeyTag, (Object)descriptionTranslationKeysTag);
            } else {
                Dynamic componentData = tag.createMap((Map)ImmutableMap.of((Object)tag.createString("command"), (Object)((Dynamic)commandTag.get()), (Object)tag.createString("nameTranslationKey"), (Object)((Dynamic)nameTranslationKeyTag.get()), (Object)tag.createString("descriptionTranslationKeys"), (Object)((Dynamic)descriptionTranslationKeysTag.get())));
                itemStackData.method_57263("iportal:command_stick_data", componentData);
                LOGGER.info("Fixed command stick item data {}", (Object)componentData);
            }
        }
        if (itemStackData.method_57270("immersive_portals:portal_wand")) {
            itemStackData.method_57266("mode", "iportal:portal_wand_data");
        }
    }
}

